/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.block.ICustomizableDrops;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.skills.MotherlodeSkill;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class CrystalOre
extends BaseBlock
implements ICustomizableDrops {
    public CrystalOre(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.3f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_235861_h_());
    }

    @Override
    public List<ItemStack> getCustomDrops(LootTable table, LootContext context) {
        PlayerEntity player = (PlayerEntity)context.func_216031_c(LootParameters.field_216281_a);
        IPlayerData data = (IPlayerData)PlayerData.get(player).orElse(null);
        if (data == null) {
            return Collections.emptyList();
        }
        ISkillProvider provider = data.getSkillProvider();
        MotherlodeSkill skill = SkillUtil.getTopHierarchySkill(Skills.MOTHER_LODE_I, provider);
        List drops = table.func_216113_a(context);
        if (skill != null) {
            int multiplier = skill.getDropMultiplier(player.func_70681_au(), data) - 1;
            ArrayList<ItemStack> addedDrops = new ArrayList<ItemStack>();
            for (ItemStack stack2 : drops) {
                for (int i = 0; i < multiplier; ++i) {
                    addedDrops.add(stack2.func_77946_l());
                }
            }
            drops.addAll(addedDrops);
        }
        drops.forEach(stack -> {
            Crystal crystal = Crystal.generate();
            CompoundNBT nbt = new CompoundNBT();
            CompoundNBT crystalNbt = crystal.toNbt();
            nbt.func_218657_a("crystal", (INBT)crystalNbt);
            stack.func_77982_d(nbt);
        });
        return drops;
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return MathHelper.func_76136_a((Random)this.RANDOM, (int)2, (int)5);
    }
}

